<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'es', branch 'MOODLE_36_STABLE'
 *
 * @package   forum
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Hay nuevos mensajes en el foro';
$string['addanewdiscussion'] = 'Añadir un nuevo tema de discusión';
$string['addanewquestion'] = 'Añadir una nueva pregunta';
$string['addanewtopic'] = 'Añadir un nuevo tema';
$string['advancedsearch'] = 'Búsqueda avanzada';
$string['allforums'] = 'Todos los foros';
$string['allowdiscussions'] = 'Permitir que cualquier {$a} abra nuevos temas';
$string['allowsallsubscribe'] = 'Este foro permite que cualquiera elija suscribirse o no';
$string['allowsdiscussions'] = 'Foro abierto a todos';
$string['allsubscribe'] = 'Suscribirse a todos los foros';
$string['allunsubscribe'] = 'Darse de baja de la suscripción de todos los foros';
$string['alreadyfirstpost'] = 'Éste es ya el primer mensaje del debate';
$string['anyfile'] = 'Cualquier archivo';
$string['areaattachment'] = 'Archivos adjuntos';
$string['areapost'] = 'Mensajes';
$string['attachment'] = 'Archivo adjunto';
$string['attachment_help'] = 'Si lo desea, puede adjuntar uno o más archivos a un mensaje en el foro. Si adjunta una imagen, se mostrará al final del mensaje.';
$string['attachmentnopost'] = 'No puede exportar archivos adjuntos sin una id de mensaje';
$string['attachments'] = 'Archivos adjuntos';
$string['attachmentswordcount'] = 'Adjuntos y recuento de palabras';
$string['blockafter'] = 'Umbral de mensajes para bloqueo';
$string['blockafter_help'] = 'Este ajuste especifica el número máximo de aportaciones que un usuario puede publicar en el período de tiempo especificado. Los usuarios con el permiso \'mod/forum:postwithoutthrottling\'  están exentos de esta limitación.';
$string['blockperiod'] = 'Período de tiempo para bloqueo';
$string['blockperioddisabled'] = 'No bloquear';
$string['blockperiod_help'] = 'Se puede impedir que los estudiantes puedan publicar más aportaciones que las especificadas por número determinado dentro de un periodo de tiempo.
Los usuarios con el permiso \'moodle/forum:ostwithoutthrottling\' están exentos de esta limitación. ';
$string['blogforum'] = 'Foro estándar que aparece en un formato de blog.';
$string['bynameondate'] = 'de {$a->name} - {$a->date}';
$string['cannotadd'] = 'No se ha podido añadir la discusión a este foro';
$string['cannotadddiscussion'] = 'Para añadir debates a este foro hay que ser miembro de un grupo.';
$string['cannotadddiscussionall'] = 'No tiene permiso para añadir un nuevo tema de discusión para todos los participantes.';
$string['cannotaddsubscriber'] = 'No se pudo añadirun suscriptor con la id {$a} a este foro.';
$string['cannotaddteacherforumto'] = 'No se ha podido convertir el ejemplo de foro de profesores a la sección 0 del curso';
$string['cannotcreatediscussion'] = 'No se pudo crear un debate nuevo';
$string['cannotcreateinstanceforteacher'] = 'No se pudo crear un nuevo ejemplo de móduno de curso para el foro de profesores';
$string['cannotdeletepost'] = 'No puede eliminar este mensaje.';
$string['cannoteditposts'] = 'No puede eliminar los mensajes de otras personas.';
$string['cannotfinddiscussion'] = 'No se ha podido encontrar el debate en este foro';
$string['cannotfindfirstpost'] = 'No se pudo encontrar el primer mensaje en este foro';
$string['cannotfindorcreateforum'] = 'No se pudo encontrar o crear un foro principal de noticias en este sitio';
$string['cannotfindparentpost'] = 'No se pudo encontrar la categoría padre del mensaje {$a}';
$string['cannotmovefromsingleforum'] = 'No se puede mover un debate desde un foro de debate simple';
$string['cannotmovenotvisible'] = 'Foro no visible';
$string['cannotmovetonotexist'] = 'No puede mover nada a ese foro, no existe';
$string['cannotmovetonotfound'] = 'Foro de destino no encontrado en este curso.';
$string['cannotmovetosingleforum'] = 'No se puede mover la discusión a un foro de discusión simple.';
$string['cannotpurgecachedrss'] = 'No se han podido purgar los canales RSS en caché en los foros de partida y de destino: compruebe sus permisos';
$string['cannotremovesubscriber'] = 'No se pudo eliminar al suscriptor con id {$a} de este foro.';
$string['cannotreply'] = 'No puede replicar a este mensaje';
$string['cannotsplit'] = 'Los debates de este foro no pueden dividirse';
$string['cannotsubscribe'] = 'Lo sentimos, debe ser un miembro de un grupo para suscribirse.';
$string['cannottrack'] = 'No se pudo parar de rastrear ese foro';
$string['cannotunsubscribe'] = 'No se pudo darle de baja en ese foro';
$string['cannotupdatepost'] = 'No puede actualizar este mensaje';
$string['cannotviewpostyet'] = 'No puede leer las preguntas de otros estudiantes en esta discusión porque usted aún no ha enviado mensajes';
$string['cannotviewusersposts'] = 'No hay aportaciones realizadas por este usuario que usted pueda ver.';
$string['cleanreadtime'] = 'Hora para marcar mensajes antiguos como leídos';
$string['clicktosubscribe'] = 'Usted no está suscrito a esta discusión. Haga clic aquí para suscribirse.';
$string['clicktounsubscribe'] = 'Usted está suscrito a este debate. Haga clic para cancelar la suscripción.';
$string['completiondiscussions'] = 'El usuario debe crear debates::';
$string['completiondiscussionsgroup'] = 'Requerir debates';
$string['completiondiscussionshelp'] = 'se requieren debates para completar';
$string['completionposts'] = 'El usuario debe enviar debates o réplicas:';
$string['completionpostsgroup'] = 'Requerir mensajes';
$string['completionpostshelp'] = 'se requieren debates o réplicas para completar';
$string['completionreplies'] = 'El usuario debe enviar réplicas:';
$string['completionrepliesgroup'] = 'Requerir réplicas';
$string['completionreplieshelp'] = 'se requieren réplicas para completar';
$string['configcleanreadtime'] = 'Hora del día para limpiar mensajes antiguos de la tabla de lectura.';
$string['configdigestmailtime'] = 'Se enviará un resumen de los correos a las personas que eligen dicha opción. Este ajuste controla a qué hora del día se enviará el correo (por medio del primer cron que se ejecute después de la hora fijada).';
$string['configdisplaymode'] = 'Visualización por defecto de los debates, si no se ha configurado ninguna.';
$string['configenablerssfeeds'] = 'Esta opción habilita la posibilidad de canales RSS para todos los foros. Aún así necesitará activar manualmente los canales en los ajustes de cada foro.';
$string['configenabletimedposts'] = 'Seleccione \'sí\' si desea permitir el ajuste de períodos en los que se mostrará un nuevo debate en el foro.';
$string['configlongpost'] = 'Cualquier mensaje que exceda esta extensión (sin incluir código HTML) se considera largo. Las aportaciones mostradas en la página principal del sitio, en las páginas de los cursos con formato social o en los perfiles de usuario, están ordenados de forma natural entre los valores forum_shortpost y forum_longpost';
$string['configmanydiscussions'] = 'Máximo número de debates mostrados en una página de foro.';
$string['configmaxattachments'] = 'Máximo número de archivos adjuntos que se permiten por mensaje.';
$string['configmaxbytes'] = 'Tamaño máximo por defecto para los archivos adjuntos a los mensajes de los foros en este sitio (sujeto a los límites del curso y otras configuraciones del servidor)';
$string['configoldpostdays'] = 'Número de días para que un mensaje se considere leído.';
$string['configreplytouser'] = 'Cuando un mensaje del foro es enviado por correo electrónico, ¿debería contener la dirección del usuario de modo que los receptores pudieran responderle personalmente en lugar de hacerlo en el foro? Incluso aunque se seleccione \'Sí\', los usuarios pueden elegir en su perfil que su dirección de correo electrónico se mantenga en secreto.';
$string['configrssarticlesdefault'] = 'Si los canales de RSS están habilitados, establece el número de artículos por defecto (debates o temas).';
$string['configrsstypedefault'] = 'Si los canales RSS están habilitados, establece el tipo de actividad por defecto.';
$string['configshortpost'] = 'Cualquier mensaje que no alcance esta extensión (sin incluir código HTML) se considera corto.';
$string['configtrackingtype'] = 'Ajuste predeterminado para el rastreo de lectura';
$string['configtrackreadposts'] = 'Seleccione \'Sí\' si desea rastrear leído/no leído para cada usuario.';
$string['configusermarksread'] = 'Si elige \'sí\' el usuario debe marcar manualmente un mensaje como leído. Si \'no\', cuando el mensaje sea visto se marcará como leído.';
$string['confirmsubscribe'] = '¿Está seguro que quiere suscribirse al foro \'{$a}\'?';
$string['confirmsubscribediscussion'] = '¿Realmente quiere suscribirse a la discusión \'{$a->discussion}\' en el foro \'{$a->forum}\'?';
$string['confirmunsubscribe'] = '¿Está seguro que quiere darse de baja de foro \'{$a}\'?';
$string['confirmunsubscribediscussion'] = '¿Realmente quiere anular la suscripción a la discusión \'{$a->discussion}\' en el foro \'{$a->forum}\'?';
$string['couldnotadd'] = 'No se puede colocar su mensaje debido a un problema desconocido.';
$string['couldnotdeletereplies'] = 'Lo sentimos, no podemos borrar este mensaje debido a que tiene réplicas.';
$string['couldnotupdate'] = 'No se ha podido actualizar su mensaje debido a un error desconocido.';
$string['crontask'] = 'Correos del foro y trabajos de mantenimiento';
$string['delete'] = 'Borrar';
$string['deleteddiscussion'] = 'El tema se ha borrado';
$string['deletedpost'] = 'El mensaje se ha borrado';
$string['deletedposts'] = 'Los mensajes han sido borrados';
$string['deletesure'] = '¿Está seguro de que desea borrar este mensaje?';
$string['deletesureplural'] = '¿Está seguro de que desea borrar este mensaje y todas las réplicas? ({$a} mensajes)';
$string['digestmailheader'] = 'Éste es su resumen diario por correo de los nuevos mensajes de los foros de {$a->sitename}. Si desea cambiar sus preferencias de foro por correo, hágalo en {$a->userprefs}.';
$string['digestmailpost'] = 'Modifique sus preferencias de suscripción';
$string['digestmailpostlink'] = 'Cambiar sus preferencias de resumen del foro: {$a}';
$string['digestmailprefs'] = 'su perfil de usuario';
$string['digestmailsubject'] = 'Resumen diario del foro de {$a}';
$string['digestmailtime'] = 'Hora para enviar los mensajes resumen';
$string['digestsentusers'] = 'Resúmenes de correo enviados con éxito a {$a} usuarios.';
$string['disallowsubscribe'] = 'No se permiten suscripciones';
$string['disallowsubscribeteacher'] = 'No se permiten suscripciones (excepto para profesores)';
$string['disallowsubscription'] = 'Suscripción';
$string['disallowsubscription_help'] = 'Este foro ha sido configurado de tal forma que usted no puede suscribirse a los debates.';
$string['discussion'] = 'Tema';
$string['discussionlocked'] = 'Este tema ha sido bloqueado así que no podrás responder en el.';
$string['discussionlockingdisabled'] = 'No bloquear discusiones';
$string['discussionlockingheader'] = 'Bloqueando discusión';
$string['discussionmoved'] = 'Este tema se ha movido a \'{$a}\'.';
$string['discussionmovedpost'] = 'Esta discusión ha sido trasladada a <a href="{$a->discusshref}">aquí</a> en el foro <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Denominación';
$string['discussionnownotsubscribed'] = '{$a->name} NO recibirá notificaciones de las nuevas publicaciones en \'{$a->discussion}\' de \'{$a->forum}\'';
$string['discussionnowsubscribed'] = '{$a->name}  recibirá notificación de nuevas aportaciones en \'{$a->discussion}\' de\'{$a->forum}\'';
$string['discussionpin'] = 'Fijar';
$string['discussionpinned'] = 'Fijado';
$string['discussionpinned_help'] = 'Los debates fijados aparecerán en la parte superior del foro.';
$string['discussions'] = 'Debates';
$string['discussionsstartedby'] = 'Debate comenzado por {$a}';
$string['discussionsstartedbyrecent'] = 'Debate recientemente comenzado por {$a}';
$string['discussionsstartedbyuserincourse'] = 'Discusiones iniciadas por {$a->fullname} en {$a->coursename}';
$string['discussionsubscribestart'] = 'Enviarme notificaciones de nuevas participaciones en este debate';
$string['discussionsubscribestop'] = 'No desea recibir notificaciones de nuevas participaciones en este debate';
$string['discussionsubscription'] = 'Suscripción a la discusión';
$string['discussionsubscription_help'] = 'Al suscribirse a una discusión, recibirá notificaciones de las nuevas publicaciones en dicha discusión.';
$string['discussionunpin'] = 'Quitar fijado';
$string['discussthistopic'] = 'Hacer un comentario en este tema';
$string['displayend'] = 'Mostrar final';
$string['displayend_help'] = 'Este ajuste especifica si un mensaje en el foro debe estar oculto después de una fecha determinada. Tenga en cuenta que los administradores siempre pueden ver los mensajes en el foro.';
$string['displaymode'] = 'Mostrar modo';
$string['displayperiod'] = 'Mostrar período';
$string['displaystart'] = 'Mostrar inicio';
$string['displaystart_help'] = 'Este ajuste especifica si un mensaje en el foro debe mostrarse a partir de una fecha determinada. Tenga en cuenta que los administradores siempre pueden ver los mensajes en el foro.';
$string['displaywordcount'] = 'Mostrar número de palabras';
$string['displaywordcount_help'] = 'Este ajuste especifica si el número de palabras de cada mensaje se debe mostrar o no';
$string['eachuserforum'] = 'Cada persona plantea un tema';
$string['edit'] = 'Editar';
$string['editedby'] = 'Editado por {$a->name} - envío original {$a->date}';
$string['editedpostupdated'] = '{$a} mensajes actualizados';
$string['editing'] = 'Editando';
$string['emaildigestcompleteshort'] = 'Mensajes completos';
$string['emaildigestdefault'] = 'Por defecto ({$a})';
$string['emaildigestoffshort'] = 'Sin resumen';
$string['emaildigestsubjectsshort'] = 'Solo asuntos';
$string['emaildigesttype'] = 'Opciones de resumen de correo';
$string['emaildigesttype_help'] = 'Tipo de notificación que recibirá de cada foro:

* Por defecto - Sigue los ajustes de resumen de correo de su perfil de usuario. Si actualiza su perfil, los cambios se verán reflejados también aquí;
* Sin resumen - Recibirá un correo por cada mensaje del foro;
* Resumen - mensajes completos- Recibirá un resumen de correo diario con el contenido completo de cada mensaje del foro;
* Resumen - sólo asunto- Recibirá un resumen de correo diario sólo con el asunto de cada mensaje del foro.';
$string['emptymessage'] = 'Algo va mal con su mensaje. Tal vez lo haya enviado en blanco o el archivo adjunto, si lo hay, es demasiado grande. Sus cambios NO se han guardado.';
$string['erroremptymessage'] = 'El mensaje no puede estar vacío';
$string['erroremptysubject'] = 'El asunto del mensaje no puede estar vacío.';
$string['errorenrolmentrequired'] = 'Es necesario estar matriculado en este curso para poder acceder al contenido.';
$string['errorwhiledelete'] = 'Ha ocurrido un error al eliminar el registro';
$string['eventassessableuploaded'] = 'Algún contenido ha sido publicado.';
$string['eventcoursesearched'] = 'Curso buscado';
$string['eventdiscussioncreated'] = 'Tema creado';
$string['eventdiscussiondeleted'] = 'Tema borrado';
$string['eventdiscussionmoved'] = 'Tema movido';
$string['eventdiscussionpinned'] = 'Debate fijado';
$string['eventdiscussionsubscriptioncreated'] = 'Se ha suscrito a esta discusión';
$string['eventdiscussionsubscriptiondeleted'] = 'Se ha borrado la suscripción de esta discusión';
$string['eventdiscussionunpinned'] = 'Debate no fijado';
$string['eventdiscussionupdated'] = 'Discusión actualizada';
$string['eventdiscussionviewed'] = 'Tema visto';
$string['eventpostcreated'] = 'Mensaje creado';
$string['eventpostdeleted'] = 'Mensaje borrado';
$string['eventpostupdated'] = 'Mensaje actualizado';
$string['eventreadtrackingdisabled'] = 'Seguimiento de lectura deshabilitado';
$string['eventreadtrackingenabled'] = 'Seguimiento de lectura habilitado';
$string['eventsubscribersviewed'] = 'Suscriptores visualizados';
$string['eventsubscriptioncreated'] = 'Suscripción activada';
$string['eventsubscriptiondeleted'] = 'Suscripción anulada';
$string['eventuserreportviewed'] = 'Informe del usuario visualizado';
$string['everyonecanchoose'] = 'Todos pueden suscribirse';
$string['everyonecannowchoose'] = 'Ahora cualquiera puede elegir si se suscribe';
$string['everyoneisnowsubscribed'] = 'Ahora todos están suscritos a este foro';
$string['everyoneissubscribed'] = 'Todos están suscritos a este foro';
$string['existingsubscribers'] = 'Suscriptores existentes';
$string['exportdiscussion'] = 'Exportar el debate completo al portafolio';
$string['forcedreadtracking'] = 'Permitir forzar el rastreo de lectura';
$string['forcedreadtracking_desc'] = 'Permite que en los foros se establezca forzar el rastreo de lectura. Dará como resultado una disminución del rendimiento para algunos usuarios, sobre todo en cursos con muchos foros y mensajes. Cuando está deshabilitado, los foros establecidos previamente en Siempre se tratarán como opcional.';
$string['forcesubscribed'] = 'Este foro fuerza la suscripción de todos';
$string['forcesubscribed_help'] = 'Este foro se ha configurado de manera que usted no puede darse de baja de las discusiones.';
$string['forum'] = 'Foro';
$string['forum:addinstance'] = 'Añadir un nuevo foro';
$string['forum:addnews'] = 'Añadir noticias';
$string['forum:addquestion'] = 'Añadir pregunta';
$string['forum:allowforcesubscribe'] = 'Permitir la suscripción forzosa.';
$string['forumauthorhidden'] = 'Autor (oculto)';
$string['forumblockingalmosttoomanyposts'] = 'Usted se está aproximando al límite permitido de mensajes. Ha enviado {$a->numposts} mensajes en el último {$a->blockperiod} y el límite está en {$a->blockafter} mensajes.';
$string['forumbodyhidden'] = 'Usted no puede ver este mensaje, probablemente debido a que aún no ha enviado mensajes a esta discusión, a que el margen de tiempo de edición no ha pasado todavía, a que el debate todavía no ha comentado o a que el debate ya ha expirado.';
$string['forum:canoverridediscussionlock'] = 'Contestar a discusiones bloqueadas';
$string['forum:canposttomygroups'] = 'Puede publicar en todos los grupos en los que tiene acceso';
$string['forum:createattachment'] = 'Crear archivos adjuntos';
$string['forum:deleteanypost'] = 'Eliminar cualquier mensaje (en cualquier momento)';
$string['forum:deleteownpost'] = 'Eliminar mensajes propios (antes de la fecha límite)';
$string['forum:editanypost'] = 'Editar cualquier mensaje';
$string['forum:exportdiscussion'] = 'Exportar discusión completa';
$string['forum:exportownpost'] = 'Exportar mensaje propio';
$string['forum:exportpost'] = 'Exportar mensaje';
$string['forumintro'] = 'Descripción';
$string['forum:managesubscriptions'] = 'Gestionar suscripciones';
$string['forum:movediscussions'] = 'Trasladar debates';
$string['forumname'] = 'Nombre del foro';
$string['forum:pindiscussions'] = 'Debates fijados';
$string['forumposts'] = 'Mensajes en foros';
$string['forum:postwithoutthrottling'] = 'Exentos del umbral de mensaje';
$string['forum:rate'] = 'Calificar mensajes';
$string['forum:replynews'] = 'Responder a noticias';
$string['forum:replypost'] = 'Replicar a mensajes';
$string['forums'] = 'Foros';
$string['forum:splitdiscussions'] = 'Dividir debates';
$string['forum:startdiscussion'] = 'Comenzar nuevos debates';
$string['forumsubjecthidden'] = 'Tema (oculto)';
$string['forumtracked'] = 'Se están rastreando los mensajes no leídos';
$string['forumtrackednot'] = 'Los mensajes no leídos no se están rastreando';
$string['forumtype'] = 'Tipo de foro';
$string['forumtype_help'] = 'Hay cinco tipos diferentes de foros:

* Cada persona plantea un tema - Cada persona puede plantear un nuevo tema de debate (y todos pueden responder). Esta modalidad es útil cuando usted quiere que cada estudiante empiece una discusión sobre, digamos, sus reflexiones sobre el tema de la semana, y que todos los demás le respondan.

* Un debate sencillo. - Es simplemente un intercambio de ideas sobre un solo tema, todo en un página. Útil para debates cortos y concretos.

* Foro P y R: Pregunta y Respuestas. -  Los estudiantes primero deben fijar sus puntos de vista antes de ver los mensajes de los demás.

* Foro General con formato de Blog. - Un foro abierto donde cualquiera puede iniciar un nuevo debate en cualquier momento y en el que los temas de discusión se muestran en una página con enlaces "Discute este tema".

* Foro para uso general. -  Es un foro abierto donde cualquiera puede empezar un nuevo tema de debate cuando quiera. Este es el foro más adecuado, para uso general.';
$string['forum:viewallratings'] = 'Ver todas las calificaciones emitidas por las usuarios';
$string['forum:viewanyrating'] = 'Ver el total de calificaciones que alguien recibió';
$string['forum:viewdiscussion'] = 'Ver debates';
$string['forum:viewhiddentimedposts'] = 'Ver mensajes programados ocultos';
$string['forum:viewqandawithoutposting'] = 'Ver siempre mensajes de P y R';
$string['forum:viewrating'] = 'Ver calificación total recibida';
$string['forum:viewsubscribers'] = 'Ver suscriptores';
$string['generalforum'] = 'Foro para uso general';
$string['generalforums'] = 'Foros generales';
$string['hiddenforumpost'] = 'Publicación del foro oculta';
$string['indicator:cognitivedepth'] = 'Foro cognitivo';
$string['indicator:cognitivedepth_help'] = 'Este indicador está basado en la profundidad cognitiva alcanzada por el estudiante en una actividad Foro.';
$string['indicator:socialbreadth'] = 'Foro social';
$string['indicator:socialbreadth_help'] = 'Este indicador está basado en la amplitud social alcanzada por el estudiante en una actividad Foro.';
$string['inforum'] = 'en {$a}';
$string['introblog'] = 'Los mensajes de este foro fueron copiados aquí de forma automática a partir de los blogs de los usuarios de este curso debido a que esas entradas de blog ya no están disponibles';
$string['intronews'] = 'Avisos y novedades generales';
$string['introsocial'] = 'Foro abierto a todos los temas';
$string['introteacher'] = 'Foro exclusivo para profesores';
$string['invalidaccess'] = 'No se ha accedido correctamente a esta página';
$string['invaliddigestsetting'] = 'Se ha proporcionado un ajuste de resumen de correo no válido';
$string['invaliddiscussionid'] = 'El ID de la discusión es incorrecto o ya no existe';
$string['invalidforcesubscribe'] = 'Modo de suscripción forzada no válido';
$string['invalidforumid'] = 'El ID del foro es incorrecto';
$string['invalidparentpostid'] = 'La ID del mensaje padre es incorrecta';
$string['invalidpostid'] = 'ID de mensaje no válido - {$a}';
$string['lastpost'] = 'Último mensaje';
$string['learningforums'] = 'Foros de aprendizaje';
$string['lockdiscussionafter'] = 'Bloquear discusiones después de un tiempo de inactividad';
$string['longpost'] = 'Mensaje largo';
$string['mailnow'] = 'Enviar notificaciones del tema sin tiempo de espera para edición';
$string['manydiscussions'] = 'Debates por página';
$string['markalldread'] = 'Marcar como leídos todos los mensajes de este debate.';
$string['markallread'] = 'Marcar como leídos todos los mensajes de este foro.';
$string['markasreadonnotification'] = 'Cuando se envía la notificación de un mensaje del foro';
$string['markasreadonnotificationno'] = 'No marcar el hilo como leído';
$string['markasreadonnotificationyes'] = 'Marcar el hilo como leído';
$string['markread'] = 'Marcar como leído';
$string['markreadbutton'] = 'Marcar<br />leídos';
$string['markunread'] = 'Marcar como no leído';
$string['markunreadbutton'] = 'Marcar<br />no leídos';
$string['maxattachments'] = 'Número máximo de archivos adjuntos';
$string['maxattachments_help'] = 'Este ajuste especifica si el número de palabras de cada mensaje se debe mostrar o no';
$string['maxattachmentsize'] = 'Tamaño máximo del archivo adjunto';
$string['maxattachmentsize_help'] = 'Este ajuste especifica el tamaño máximo de archivo que se puede adjuntar a un mensaje en el foro.';
$string['maxtimehaspassed'] = 'Lo sentimos, pero el tiempo máximo para editar ({$a}) ya venció.';
$string['message'] = 'Mensaje';
$string['messageinboundattachmentdisallowed'] = 'No ha sido posible publicar su respuesta debido a que incluye un fichero adjunto y el foro no permite incluir adjuntos.';
$string['messageinboundfilecountexceeded'] = 'No ha sido posible publicar su respuesta debido a que incluye más ficheros adjuntos que los que permite el foro ({$a->forum->maxattachments}).';
$string['messageinboundfilesizeexceeded'] = 'No ha sido posible publicar su respuesta debido a que el tamaño total del fichero adjunto ({$a->filesize}) es superior al tamaño máximo que se permite en el foro ({$a->maxbytes}).';
$string['messageinboundforumhidden'] = 'No ha sido posible publicar su respuesta debido a que el foro no se encuentra disponible en estos momentos.';
$string['messageinboundnopostforum'] = 'No ha sido posible publicar su respuesta debido a que no tiene permiso para publicar en el foro {$a->forum->name}.';
$string['messageinboundthresholdhit'] = 'No ha sido posible publicar su respuesta.  Ha superado el límite de publicaciones determinadas para este foro';
$string['messageprovider:digests'] = 'Compendios suscritos del foro';
$string['messageprovider:posts'] = 'Mensajes suscritos del foro';
$string['missingsearchterms'] = 'Los siguientes términos de búsqueda sólo tienen lugar en la marca HTML de este mensaje:';
$string['modeflatnewestfirst'] = 'Ordenar desde el más reciente';
$string['modeflatoldestfirst'] = 'Ordenar desde el más antiguo';
$string['modenested'] = 'Mostrar respuestas anidadas';
$string['modethreaded'] = 'Mostrar respuestas por rama';
$string['modulename'] = 'Foro';
$string['modulename_help'] = 'El módulo de actividad foro permite a los participantes tener discusiones asincrónicas, es decir discusiones que tienen lugar durante un período prolongado de tiempo.

Hay varios tipos de foro para elegir, como el foro estándar donde cualquier persona puede iniciar una nueva discusión en cualquier momento, un foro en el que cada alumno puede iniciar una única discusión, o un foro de pregunta y respuesta en el que los estudiantes primero deben participar antes de poder ver los mensajes de otros estudiantes. El profesor puede permitir que se adjunten archivos a las aportaciones al foro. Las imágenes adjuntas se muestran en el mensaje en el foro.

Los participantes pueden suscribirse a un foro para recibir notificaciones cuando hay nuevos mensajes en el foro. El profesor puede establecer el modo de suscripción,  opcional, forzado o auto, o prohibir completamente la suscripción. Si es necesario, los estudiantes pueden ser bloqueados a la hora de publicar más de un número determinado de mensajes en un determinado período de tiempo; esta medida puede evitar que determinadas personas dominen las discusiones.

Los mensajes en el foro puede ser evaluado por profesores o estudiantes (evaluación por pares). Las clasificaciones pueden agregarse a una calificación final que se registra en el libro de calificaciones.

Los foros tiene muchos usos, como por ejemplo

* Un espacio social para que los estudiantes se conozcan
* Para los avisos del curso (usando un foro de noticias con suscripción forzada)
* Para discutir el contenido del curso o de materiales de lectura
* Para continuar en línea una cuestión planteada previamente en una sesión presencial
* Para discusiones solo entre profesores del curso (mediante un foro oculto)
* Un centro de ayuda donde los tutores y los estudiantes pueden dar consejos
* Un área de soporte uno-a-uno para comunicaciones entre alumno y profesor (usando un foro con grupos separados y con un estudiante por grupo)
* Para actividades complementarias, como una "lluvia de ideas" donde los estudiantes puedan reflexionar y proponer ideas';
$string['modulenameplural'] = 'Foros';
$string['more'] = 'más';
$string['movedmarker'] = '(Trasladada)';
$string['movethisdiscussionto'] = 'Mover este tema a...';
$string['mustprovidediscussionorpost'] = 'Debe proporcionar una ID de discusión o mensaje para exportar';
$string['myprofileotherdis'] = 'Foros de discusión';
$string['myprofileowndis'] = 'Mis foros de discusión';
$string['myprofileownpost'] = 'Mis mensajes en el foro';
$string['namenews'] = 'Avisos';
$string['namenews_help'] = 'El foro de Avisos es un foro especial para avisos que se crea automáticamente cuando se crea un curso. Un curso puede tener sólo un foro de Avisos. Sólo los profesores y los administradores pueden escribir en el foro de Avisos. El bloque de "Avisos recientes" muestra los avisos recientes.';
$string['namesocial'] = 'Foro social';
$string['nameteacher'] = 'Foro de profesores';
$string['newforumposts'] = 'Nuevos mensajes en foros';
$string['nextdiscussiona'] = 'Nuevo debate: {$a}';
$string['noattachments'] = 'No hay archivos adjuntos a este mensaje';
$string['nodiscussions'] = 'Aún no hay temas en este foro';
$string['nodiscussionsstartedby'] = '{$a} no ha comenzado ningún debate';
$string['nodiscussionsstartedbyyou'] = 'Todavía no hay ningún debate iniciado';
$string['noguestpost'] = 'Lo sentimos, los invitados no pueden enviar mensajes.';
$string['noguestsubscribe'] = 'Lo lamentamos pero los invitados no pueden suscribirse.';
$string['noguesttracking'] = 'Lo sentimos, los invitados no pueden ajustar opciones de rastreo.';
$string['nomorepostscontaining'] = 'No se encontraron más mensajes que contengan {$a}';
$string['nonews'] = 'Sin novedades aún';
$string['noonecansubscribenow'] = 'Las suscripciones no están permitidas ahora';
$string['nopermissiontosubscribe'] = 'No tiene permiso para ver los suscriptores del foro';
$string['nopermissiontoview'] = 'No tiene permiso para ver este mensaje';
$string['nopostforum'] = 'Lo sentimos, no puede enviar mensajes a este foro';
$string['noposts'] = 'No hay mensajes';
$string['nopostsmadebyuser'] = '{$a} no ha realizado aportaciones';
$string['nopostsmadebyyou'] = 'Todavía no se han realizado aportaciones';
$string['noquestions'] = 'Aún no hay preguntas en este foro';
$string['nosubscribers'] = 'Nadie se ha suscrito aún a este foro';
$string['notexists'] = 'El debate ya no existe';
$string['nothingnew'] = 'Nada nuevo para {$a}';
$string['notingroup'] = 'Lo sentimos, pero debe formar parte del grupo para poder ver este foro.';
$string['notinstalled'] = 'El módulo foro no está instalado';
$string['notpartofdiscussion'] = 'Este mensaje no es parte de ningún debate';
$string['notrackforum'] = 'No rastrear mensajes no leídos';
$string['notsubscribed'] = 'Suscribir';
$string['noviewdiscussionspermission'] = 'No dispone de permiso para ver los debates de este foro';
$string['nowallsubscribed'] = 'Todos los foros en {$a} están suscritos.';
$string['nowallunsubscribed'] = 'Todos los foros en {$a} están dados de baja.';
$string['nownotsubscribed'] = '{$a->name} no recibirá notificaciones de nuevas aportaciones al foro \'{$a->forum}\'';
$string['nownottracking'] = '{$a->name} ya no está rastreando \'{$a->forum}\'.';
$string['nowsubscribed'] = '{$a->name} recibirá notificación de nuevas aportaciones en {$a->forum}\' por correo.';
$string['nowtracking'] = '{$a->name} está rastreando \'{$a->forum}\' en este momento.';
$string['numposts'] = '{$a} mensajes';
$string['olderdiscussions'] = 'Mensajes anteriores';
$string['oldertopics'] = 'Temas antiguos';
$string['oldpostdays'] = 'Leer después de días';
$string['overviewnumpostssince'] = '{$a} mensajes desde la última entrada';
$string['overviewnumunread'] = '{$a} mensajes no leídos';
$string['page-mod-forum-discuss'] = 'Página de hilo de discusión del módulo foro';
$string['page-mod-forum-view'] = 'Página principal del módulo Foro';
$string['page-mod-forum-x'] = 'Cualquier página del módulo Foro';
$string['parent'] = 'Mostrar mensaje anterior';
$string['parentofthispost'] = 'Anterior a este mensaje';
$string['permalink'] = 'Enlace permanente';
$string['pluginadministration'] = 'Administración del foro';
$string['pluginname'] = 'Foro';
$string['postadded'] = '<p>Su mensaje se ha enviado con éxito.</p> <p>Tiene {$a} para editar si desea hacer cualquier cambio.</p>';
$string['postaddedsuccess'] = 'Su mensaje ha sido añadido con éxito.';
$string['postaddedtimeleft'] = 'Dispone de {$a} para editarlo si quiere hacer cualquier cambio.';
$string['postbymailsuccess'] = 'Felicidades, su publicación en el foro con el asunto "{$a->subject}" ha sido incorporada con éxito. Puede verla en {$a->discussionurl}.';
$string['postbymailsuccess_html'] = 'Felicidades, su <a href="{$a->discussionurl}">publicación en el foro</a> con el asunto "{$a->subject}" ha sido publicada con éxito.';
$string['postbyuser'] = '{$a->post} por {$a->user}';
$string['postincontext'] = 'Ver el mensaje en su contexto';
$string['postmailinfolink'] = 'Esta es una copia de un mensaje enviado a {$a->coursename}.

Para responder haga clic en el link: {$a->replylink}';
$string['postmailnow'] = '<p>Este mensaje será enviado inmediatamente a todos los suscritos al foro.</p>';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['postrating1'] = 'Muy individualista';
$string['postrating2'] = 'Término medio';
$string['postrating3'] = 'Muy comunicativo';
$string['posts'] = 'Mensajes';
$string['postsmadebyuser'] = 'Aportación realizada por {$a}';
$string['postsmadebyuserincourse'] = 'Aportación realizada por {$a->fullname} en {$a->coursename}';
$string['posttoforum'] = 'Enviar al foro';
$string['posttomygroups'] = 'Publicar una copia para todos los grupos';
$string['posttomygroups_help'] = 'Publica una copia de este mensaje en todos los grupos a los que tenga acceso. Los participantes de los grupos a los que no tenga acceso no verán esta publicación';
$string['postupdated'] = 'Su mensaje se ha actualizado';
$string['potentialsubscribers'] = 'Suscriptores potenciales';
$string['prevdiscussiona'] = 'Debate anterior: {$a}';
$string['processingdigest'] = 'Procesando el resumen por correo para el usuario {$a}';
$string['processingpost'] = 'Procesando {$a}';
$string['prune'] = 'Dividir';
$string['prunedpost'] = 'Se ha creado un nuevo debate a partir de ese mensaje';
$string['pruneheading'] = 'Dividir la discusión y mover esta entrada a una nueva discusión';
$string['qandaforum'] = 'Foro P y R';
$string['qandanotify'] = 'Este es un foro de Preguntas y Respuestas. Para ver otras respuestas, debe primero enviar la suya';
$string['re'] = 'Re:';
$string['readtherest'] = 'Ver el resto del tema';
$string['replies'] = 'Réplicas';
$string['repliesmany'] = '{$a} réplicas';
$string['repliesone'] = '{$a} respuesta';
$string['reply'] = 'Responder';
$string['replyforum'] = 'Responder al foro';
$string['reply_handler'] = 'Responder a los mensajes en el foro vía correo electrónico';
$string['reply_handler_name'] = 'Responder a las publicaciones del foro';
$string['replytopostbyemail'] = 'Puede responder al mensaje mediante email.';
$string['replytouser'] = 'Usar dirección email en réplica';
$string['resetdigests'] = 'Borrar todas las preferencias de resumen de correo de usuarios';
$string['resetforums'] = 'Eliminar mensajes de';
$string['resetforumsall'] = 'Eliminar todos los mensajes';
$string['resetsubscriptions'] = 'Eliminar todas las suscripciones al foro';
$string['resettrackprefs'] = 'Eliminar todas las preferencias de rastreo de los foros';
$string['rssarticles'] = 'Número de artículos recientes RSS';
$string['rssarticles_help'] = 'Este ajuste especifica el número de artículos (ya sean debates o aportaciones) a incluir en el canal RSS. Un número entre 5 y 20 se considera aceptable.';
$string['rsssubscriberssdiscussions'] = 'Canal RSS de debates';
$string['rsssubscriberssposts'] = 'Canal RSS de mensajes';
$string['rsstype'] = 'Canal RSS de esta actividad';
$string['rsstypedefault'] = 'Tipo de feed RSS';
$string['rsstype_help'] = '<P>Esta opción le permite habilitar los canales RSS en este foro.

<P>Puede escoger entre dos tipos de foros:
<UL>
  <LI><B>Debates:</B> Con esta opción, los datos generados incluirán nuevas
         discusiones en el foro con su mensaje inicial.
  <LI><B>Mensajes:</B> Con esta opción, los datos generados incluirán cada
         nuevo mensaje en el foro.
</UL>';
$string['search'] = 'Buscar';
$string['search:activity'] = 'Foro - información de actividad';
$string['searchdatefrom'] = 'Los mensajes deben ser posteriores a la fecha';
$string['searchdateto'] = 'Los mensajes deben ser anteriores a la fecha';
$string['searchforumintro'] = 'Por favor, introduzca las condiciones de la búsqueda en uno o en varios de los siguientes campos:';
$string['searchforums'] = 'Buscar en los foros';
$string['searchfullwords'] = 'Estas palabras deben aparecer exactamente igual';
$string['searchnotwords'] = 'Estas palabras NO deben aparecer en el mensaje';
$string['searcholderposts'] = 'Buscar mensajes antiguos...';
$string['searchphrase'] = 'Esta frase exacta debe aparecer en el mensaje';
$string['search:post'] = 'Foro - temas';
$string['searchresults'] = 'Resultado';
$string['searchsubject'] = 'Estas palabras deben aparecer en el asunto';
$string['searchuser'] = 'Este nombre debe corresponder con el del autor';
$string['searchuserid'] = 'ID del autor en Moodle';
$string['searchwhichforums'] = 'Seleccione en qué foros buscar';
$string['searchwords'] = 'Estas palabras deben aparecer en cualquier lugar dentro del mensaje';
$string['seeallposts'] = 'Ver todos los mensajes de este usuario';
$string['shortpost'] = 'Mensaje corto';
$string['showsubscribers'] = 'Mostrar/editar suscriptores actuales';
$string['singleforum'] = 'Debate sencillo';
$string['smallmessage'] = '{$a->user} envió un mensaje a {$a->forumname}';
$string['smallmessagedigest'] = 'Resumen de foro conteniendo {$a} mensajes';
$string['startedby'] = 'Comenzado por';
$string['subject'] = 'Asunto';
$string['subscribe'] = 'Suscribirse a este foro';
$string['subscribeall'] = 'Suscribir a todos a este foro';
$string['subscribed'] = 'Suscrito';
$string['subscribediscussion'] = 'Suscribirse a este tema';
$string['subscribeenrolledonly'] = 'Lo siento, sólo los usuarios registrados pueden suscribirse a las notificaciones de aportaciones en los foros';
$string['subscribenone'] = 'Dar de baja a todos de este foro';
$string['subscribers'] = 'Suscriptores';
$string['subscriberstowithcount'] = 'Suscriptores de \'{$a->name}\'  ({$a->count})';
$string['subscribestart'] = 'Deseo recibir notificaciones por correo de nuevos mensajes en este foro';
$string['subscribestop'] = 'No deseo recibir notificaciones por correo de nuevos mensajes en este foro';
$string['subscription'] = 'Suscripción';
$string['subscriptionandtracking'] = 'Suscripción y seguimiento';
$string['subscriptionauto'] = 'Suscripción automática';
$string['subscriptiondisabled'] = 'Suscripción deshabilitada';
$string['subscriptionforced'] = 'Suscripción forzosa';
$string['subscription_help'] = 'Si usted está suscrito a un foro significa que recibirá correos electrónicos con las copias de las aportaciones realizadas en el foro. Por lo general, usted puede elegir si desea estar o no suscrito a un foro, aunque a veces la suscripción es obligatoria de manera que todo el mundo recibe en su correo electrónico una copia de los mensajes del foro.';
$string['subscriptionmode'] = 'Modalidad de suscripción';
$string['subscriptionmode_help'] = 'Cuando alguien se subscribe a un foro recibirá por correo electrónico una copia de cada mensaje enviado a ese foro.

Hay 4 modos de suscripción:

* Opcional - Los participantes pueden elegir si desean ser suscritos.
* Forzosa - Todos están suscritos y no puede darse de baja.
* Automática - Todos están suscritos inicialmente pero cada usuario puede desactivar la suscripción en cualquier momento.
* Desactivada - No se permiten suscripciones.

Nota: Cualquier cambio en el modo de suscripción sólo afectará a los usuarios que se registren en el curso en el futuro y no a los usuarios existentes.';
$string['subscriptionoptional'] = 'Suscripción opcional';
$string['subscriptions'] = 'Suscripciones';
$string['thisforumisthrottled'] = 'Este foro tiene un número limitado de mensajes para enviar en un cierto período de tiempo. El ajuste normalmente se hace en {$a->blockafter} mensaje(s) en {$a->blockperiod}';
$string['timedhidden'] = 'Estado por período: Oculto para los estudiantes';
$string['timedposts'] = 'Mensajes con asignación de tiempo';
$string['timedvisible'] = 'Estado por período: visible a todos los usuarios';
$string['timestartenderror'] = 'La fecha final no puede ser anterior a la inicial';
$string['trackforum'] = 'Rastrear mensajes no leídos';
$string['tracking'] = 'Rastrear';
$string['trackingoff'] = 'Desconectado';
$string['trackingon'] = 'Forzado';
$string['trackingoptional'] = 'Opcional';
$string['trackingtype'] = 'Rastreo de lectura';
$string['trackingtype_help'] = 'El seguimiento de lectura permite a los participantes verificar rápidamente que temas no han sido leídos, destacando los temas nuevos.

Si está configurado como opcional, los participantes pueden elegir si habilitar o no el seguimiento a través de un enlace en el bloque de administración. (Los usuarios también deben habilitar el seguimiento en sus preferencias del foro).

Si \'Permitir forzar seguimiento de lectura\' está habilitado en la administración del sitio, entonces una opción más está disponible: forzado. Esto significa que, más allá de las preferencias del foro del usuario, el seguimiento está siempre habilitado.';
$string['trackreadposts_header'] = 'Seguimiento del foro';
$string['unread'] = 'No leído';
$string['unreadposts'] = 'Mensajes no leídos';
$string['unreadpostsnumber'] = '{$a} mensajes no leídos';
$string['unreadpostsone'] = '1 mensaje no leído';
$string['unsubscribe'] = 'Darse de baja de este foro';
$string['unsubscribeall'] = 'Dar de baja de todos los foros';
$string['unsubscribeallconfirm'] = 'En este momento está suscrito a {$a->forums} foros, y {$a->discussions} debates. ¿Realmente desea darse de baja de todos los foros y debates, y deshabilitar la suscripción automática a los debates?';
$string['unsubscribeallconfirmdiscussions'] = 'En este momento está suscrito a las discusiones {$a->discussions}. ¿Realmente desea anular la suscripción a todas las discusiones y deshabilitar la suscripción automática a la discusión?';
$string['unsubscribeallconfirmforums'] = 'En este momento está suscrito a los foros {$a->forums}. ¿Realmente desea anular la suscripción a todos los foros y deshabilitar la suscripción automática a la discusión?';
$string['unsubscribealldone'] = 'Se han eliminado todas sus suscripciones opcionales a los foros. Aun así, podría seguir recibiendo notificaciones de foros con suscripción forzosa. Para gestionar las notificaciones de los foros, vaya a Mensajería en los Ajustes de su Perfil.';
$string['unsubscribeallempty'] = 'No está suscrito a ningún foro. Si desea desactivar todas las notificaciones de este servidor, vaya a Mensajería en los Ajustes de su Perfil.';
$string['unsubscribed'] = 'No suscrito';
$string['unsubscribediscussion'] = 'Darse de baja de esta discusión';
$string['unsubscribediscussionlink'] = 'Darse de baja de esta discusión: {$a}';
$string['unsubscribelink'] = 'Darse de baja del foro: {$a}';
$string['unsubscribeshort'] = 'Dar de baja';
$string['usermarksread'] = 'Marcar lectura de mensaje manual';
$string['viewalldiscussions'] = 'Ver todos los debates';
$string['viewthediscussion'] = 'Ver la discusión';
$string['warnafter'] = 'Umbral de mensajes para advertencia';
$string['warnafter_help'] = 'Se puede avisar a los estudiante de que se acercan al máximo número de aportaciones permitidas en el periodo de tiempo determinado. Este parámetro especifica después de cuántas aportaciones se les debe advertir. Los usuarios con el permiso \'moodle/forum:postwitho están exentos de esta limitación.';
$string['warnformorepost'] = '¡Atención!. Hay más de una discusión en este foro - se usará la más reciente';
$string['yournewquestion'] = 'Su nueva pregunta';
$string['yournewtopic'] = 'Su nuevo tema';
$string['yourreply'] = 'Su respuesta';
