<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'es', branch 'MOODLE_26_STABLE'
 *
 * @package   local_moodlemobileapp
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.calendar.calendarevents'] = 'Eventos de calendario';
$string['addon.calendar.defaultnotificationtime'] = 'Hora de notificación por defecto';
$string['addon.calendar.errorloadevent'] = 'Error cargando el evento.';
$string['addon.calendar.errorloadevents'] = 'Error cargando los eventos.';
$string['addon.calendar.noevents'] = 'No hay eventos';
$string['addon.calendar.notifications'] = 'Notificaciones';
$string['addon.competency.errornocompetenciesfound'] = 'No se encontraron competencias';
$string['addon.competency.nocompetencies'] = 'Sin competencias';
$string['addon.coursecompletion.complete'] = 'Completado';
$string['addon.coursecompletion.couldnotloadreport'] = 'No se puede cargar el informe de finalización del curso, por favor inténtalo de nuevo más tarde.';
$string['addon.coursecompletion.status'] = 'Estado';
$string['addon.files.couldnotloadfiles'] = 'La lista de archivos no ha podido cargarse.';
$string['addon.files.emptyfilelist'] = 'No hay archivos que mostrar';
$string['addon.files.erroruploadnotworking'] = 'Desafortunadamente en estos momentos no es posible subir archivos al sitio.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Configurar dispositivos';
$string['addon.messages.contactlistempty'] = 'Lista de contactos vacía';
$string['addon.messages.contactname'] = 'Nombre del contacto';
$string['addon.messages.deletemessage'] = 'Eliminar mensaje';
$string['addon.messages.deletemessageconfirmation'] = '¿Está seguro que quiere eliminar este mensaje? Será eliminado solamente de su historial de mensaje y todavía será visible por el usuario que envió o recibió el mensaje.';
$string['addon.messages.errordeletemessage'] = 'Error borrando el mensaje.';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Error al recuperar los contactos del servidor.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Error al recuperar las discusiones del servidor.';
$string['addon.messages.errorwhileretrievingmessages'] = 'Error al recuperar los mensajes del servidor.';
$string['addon.messages.messagenotsent'] = 'El mensaje no fue enviado; por favor inténtelo nuevamente después.';
$string['addon.messages.newmessages'] = 'Nuevos mensajes';
$string['addon.messages.nousersfound'] = 'No se encuentran usuarios';
$string['addon.messages.type_blocked'] = 'Bloqueado';
$string['addon.messages.type_offline'] = 'Desconectado';
$string['addon.messages.type_online'] = 'En línea';
$string['addon.messages.type_search'] = 'Resultados de la búsqueda';
$string['addon.messages.type_strangers'] = 'Otros';
$string['addon.messages.warningmessagenotsent'] = 'No se pudo enviar mensaje(s) al usuario {{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Por favor acepte las condiciones de envío.';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'No puede añadir o editar un envío en la app porque no pudimos recuperar las condiciones de envío del sitio.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Algunos métodos de calificación no son compatibles aún con la aplicación y no se pueden modificar.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'No puede enviar para calificar en la app porque no pudimos recuperar las condiciones de envío del sitio.';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'No puede añadir o editar un envío en la app porque algunos plugins no tienen soporte para editar:';
$string['addon.mod_assign.errorshowinginformation'] = 'No se puede mostrar la información del envío';
$string['addon.mod_assign.feedbacknotsupported'] = 'La retroalimentación no está soportada por la app y podría no mostrar la información completa';
$string['addon.mod_assign.gradenotsynced'] = 'Calificación no sincronizada';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Los participantes sin envíos no se muestran';
$string['addon.mod_assign.submissionnotsupported'] = 'Este envío no está soportada por la app y es posible que no muestre la información completa';
$string['addon.mod_assign.userwithid'] = 'Usuario con ID {{id}}';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'La calificación del envío se modificó en el sitio.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'El envío del usuario fue modificado en el sitio.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Se ha producido un error conectando al chat.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Se ha producido un error recuperando los datos del chat.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Se ha producido un error recuperando los usuarios del chat.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Error al recuperar los mensajes del servidor.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Se ha producido un error al enviar el mensaje.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Usted debe de estar conectado a Internet para enviar mensajes';
$string['addon.mod_choice.errorgetchoice'] = 'Se ha producido un error recuperando los datos de la consulta.';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% de los usuarios han escogido la opción: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'Los resultados no incluyen su última respuesta. Por favor, sincronícelos para actualizarlos.';
$string['addon.mod_data.errorapproving'] = 'Error al aprobar o desaprobar una entrada.';
$string['addon.mod_data.errordeleting'] = 'Error al eliminar entrada.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'La retroalimentación con captcha no puede ser completada si no está configurada, si está en modo fuera-de-línea o con el servidor caído.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Esta retroalimentación ha sido guardada para enviarse más tarde.';
$string['addon.mod_folder.emptyfilelist'] = 'No hay archivos que mostrar.';
$string['addon.mod_forum.errorgetforum'] = 'Error al obtener datos del foro.';
$string['addon.mod_forum.errorgetgroups'] = 'Error al obtener los datos del grupo.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'No existen temas de discusión en este foro';
$string['addon.mod_forum.group'] = 'Grupo';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} discusiones';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} respuestas';
$string['addon.mod_forum.refreshdiscussions'] = 'Actualizar foro';
$string['addon.mod_forum.refreshposts'] = 'Actualizar publicaciones del foro';
$string['addon.mod_glossary.browsemode'] = 'Navegar por las entradas';
$string['addon.mod_glossary.byalphabet'] = 'Alfabéticamente';
$string['addon.mod_glossary.byauthor'] = 'Agrupado por autor';
$string['addon.mod_glossary.bycategory'] = 'Agrupar por categoría';
$string['addon.mod_glossary.bynewestfirst'] = 'El más reciente primero';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Actualizado recientemente';
$string['addon.mod_glossary.bysearch'] = 'Buscar';
$string['addon.mod_glossary.cannoteditentry'] = 'No se puede editar la entrada';
$string['addon.mod_glossary.entriestobesynced'] = 'Entradas pendientes de ser sincronizadas';
$string['addon.mod_glossary.entrypendingapproval'] = 'Esta entrada está pendiente de aprobación.';
$string['addon.mod_glossary.errorloadingentries'] = 'Ha ocurrido un error cargando las entradas.';
$string['addon.mod_glossary.errorloadingentry'] = 'Ha ocurrido un error cargando la entrada.';
$string['addon.mod_glossary.errorloadingglossary'] = 'Ha ocurrido un error cargando el glosario.';
$string['addon.mod_glossary.noentriesfound'] = 'No se han encontrado entradas.';
$string['addon.mod_glossary.searchquery'] = 'Tú búsqueda';
$string['addon.mod_imscp.showmoduledescription'] = 'Mostrar descripción';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Esta lección contiene un salto hacia una página aleatoria de contenido. No puede ser intentada en la aplicación hasta que haya sido comenzada en un navegador web.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Este intento no puede ser revisado ya que se ha terminado otro intento.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Este intento se ha terminado en fuera-de-línea.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Un intento fuera-de-línea fue sincronizado. ¿Quiere usted revisarlo?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'Este intento se terminó en el sitio.';
$string['addon.mod_lti.errorgetlti'] = 'Se ha producido un error recuperando los datos del módulo.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'La dirección URL no es válida.';
$string['addon.mod_lti.launchactivity'] = 'Ejecutar la actividad';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Error al cargar el contenido de la página.';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Este intento de cuestionario no puede enviarse por las siguientes razones:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'Este intento no se ha sincronizado desde {{$a}}. Si ha continuado este intento en otro dispositivo después de esta hora, podría perder datos.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Ocurrió un error al guardar las respuestas. ¿Está seguro de querer abandonar el cuestionario?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Este cuestionario no puede realizarse en la app porque su comportamiento no está soportado:';
$string['addon.mod_quiz.errordownloading'] = 'Error al descargar datos necesarios.';
$string['addon.mod_quiz.errorgetattempt'] = 'Error al obtener datos del intento.';
$string['addon.mod_quiz.errorgetquestions'] = 'Error al obtener las preguntas.';
$string['addon.mod_quiz.errorgetquiz'] = 'Error al obtener datos del cuestionario.';
$string['addon.mod_quiz.errorparsequestions'] = 'Ocurrió un error al leer las preguntas. Por favor intente este cuestionario desde un navegador web.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Este cuestionario no puede realizarse desde la app porque puede contener preguntas no soportadas:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Este cuestionario no puede realizarse desde la app porque tiene condiciones de acceso no soportadas:';
$string['addon.mod_quiz.errorsaveattempt'] = 'Ocurrió un error al guardar los datos del intento.';
$string['addon.mod_quiz.finishnotsynced'] = 'Finalizado pero no sincronizado.';
$string['addon.mod_quiz.opentoc'] = 'Abrir menú de navegación.';
$string['addon.mod_quiz.warningattemptfinished'] = 'El intento fuera de línea fue descartado porque fue terminado en el sitio o no fue encontrado.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Algunas respuestas fuera de línea fueron descartas porque las preguntas fueron modificadas en línea.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'El intento no fue terminado porque algunas respuestas fuera de línea fueron descartadas. Por favor, revise sus respuestas y entonces envíe el intento nuevamente.';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Se ha producido un error cargando el contenido.';
$string['addon.mod_resource.openthefile'] = 'Abrir el archivo';
$string['addon.mod_scorm.cannotcalculategrade'] = 'La calificación no se puede calcular.';
$string['addon.mod_scorm.dataattemptshown'] = 'Este dato pertenece al intento número {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Se ha producido un error creando un nuevo intento fuera de línea. Por favor inténtelo otra vez.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Se ha producido un error descargando el paquete SCORM: "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'Se ha producido un error recuperando los datos del paquete SCORM.';
$string['addon.mod_scorm.errorinvalidversion'] = 'Lo sentimos, la aplicación solo soporta SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'La descarga de paquetes SCORM está deshabilitada en esta instalación de Moodle. Contacte con el administrador.';
$string['addon.mod_scorm.errornovalidsco'] = 'Este paquete SCORM no tiene una SCO visible para cargar.';
$string['addon.mod_scorm.errorpackagefile'] = 'Lo sentimos, la aplicación solo soporta paquetes ZIP.';
$string['addon.mod_scorm.errorsyncscorm'] = 'Se ha producido un error durante la sincronización. Por favor inténtelo de nuevo.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Este intento contiene datos que todavía no se han sincronizado .';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Este intento no se puede enviar porque has sobrepasado el máximo número de intentos.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Este SCORM no se ha descargado. Lo hará automáticamente cuando lo abras.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Este SCORM se ha modificado desde la última descarga. Se descargará automáticamente cuando lo abras.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Algunos datos fuera de línea del intento {{number}} se han eliminado porque no pueden crearse en el nuevo intento.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Algunos intentos no pueden sincronizarse con el sitio porque el último intento en línea no ha finalizado. Por favor acabe primero el intento.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Lo sentimos, hay un problema enviando la encuesta. Por favor inténtelo otra vez.';
$string['addon.mod_survey.errorgetsurvey'] = 'Se ha producido un error recuperando los datos de la encuesta.';
$string['addon.mod_survey.results'] = 'Resultados';
$string['addon.mod_url.accessurl'] = 'Ir a la URL';
$string['addon.mod_url.pointingtourl'] = 'La URL donde apunta este recurso';
$string['addon.mod_wiki.errorloadingpage'] = 'Ocurrió un error al cargar la página.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Este wiki todavía no tiene ningun contenido.';
$string['addon.mod_wiki.gowikihome'] = 'Ir al inicio del wiki';
$string['addon.mod_wiki.subwiki'] = 'Subwiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'El título no debería estar vacío.';
$string['addon.mod_wiki.viewpage'] = 'Ver página';
$string['addon.mod_wiki.wikipage'] = 'Página del wiki';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Estrategia de calificación {{$a}} no soportada';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Debe introducir algún título.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'El envío fue modificado en el sitio.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'La evaluación fue modificada en el sitio.';
$string['addon.notes.userwithid'] = 'Usuario con id {{id}}';
$string['addon.notes.warningnotenotsent'] = 'No se pudieron añadir notas al curso {{course}}. {{error}}';
$string['addon.notifications.errorgetnotifications'] = 'Error al obtener notificaciones.';
$string['addon.notifications.notifications'] = 'Notificaciones';
$string['addon.notifications.playsound'] = 'Reproducir sonido';
$string['addon.notifications.therearentnotificationsyet'] = 'No hay notificaciones';
$string['appstoredescription'] = 'NOTA: Esta aplicación oficial de Moodle Mobile sólo funciona con sitios Moodle que se han configurado para permitirlo. Por favor, contacte con su administrador de Moodle si usted tiene algún problema de conexión.

Si su sitio Moodle se ha configurado correctamente, puede utilizar esta aplicación para:

- Navegar por el contenido de sus cursos, incluso sin conexión
- Recibir notificaciones instantáneas de mensajes y otros eventos
- Encontrar y contactar de forma rápida a otras personas en sus cursos
- Subir imágenes, audio, vídeos y otros archivos desde su dispositivo móvil
- Ver las calificaciones de los cursos
- ¡y más!

Por favor, vea http://docs.moodle.org/en/Mobile_app para toda la información más reciente.

Nos encantaría recibir cualquier crítica acerca de la aplicación y sus sugerencias sobre qué más quieres que pueda hacer.

La aplicación requiere los siguientes permisos:
Grabación de audio - Para la grabación de audio para subir a Moodle
Leer y modificar los contenidos de la tarjeta SD - El contenido se descarga en la tarjeta SD para que puedas verlos offline
Acceso a la red - Para ser capaz de conectar con su sitio Moodle y comprobar si está conectado o no para cambiar al modo fuera de línea
Ejecutar en el arranque - Así recibirá notificaciones locales incluso cuando la aplicación se ejecuta en segundo plano
Desactivar el modo stand - Podrá recibir las notificaciones push en cualquier momento';
$string['core.android'] = 'Android';
$string['core.cannotconnect'] = 'No se puede conectar: Verifique que la URL es correcta y que el sitio Moodle usa la versión 2.4 o posterior.';
$string['core.cannotdownloadfiles'] = 'La descarga de archivos está deshabilitada en su servicio Mobile. Por favor contacte al administrador de su sitio.';
$string['core.captureaudio'] = 'Grabar audio';
$string['core.capturedimage'] = 'Foto tomada.';
$string['core.captureimage'] = 'Tomar foto';
$string['core.capturevideo'] = 'Grabar video';
$string['core.clearsearch'] = 'Limpiar búsqueda';
$string['core.clicktoseefull'] = 'Clic para ver el contenido al completo';
$string['core.commentsnotworking'] = 'No pueden recuperarse comentarios';
$string['core.confirmcanceledit'] = '¿Está usted seguro de que quiere abandonar esta página? Se perderán todos los cambios.';
$string['core.confirmloss'] = '¿Está seguro? Se perderán todos los cambios.';
$string['core.confirmopeninbrowser'] = '¿Quiere abrirlo en el navegador?';
$string['core.contenteditingsynced'] = 'El contenido que está editando ha sido sincronizado.';
$string['core.contentlinks.chooseaccount'] = 'Escoger una cuenta';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Escoger una cuenta con la que abrir el enlace.';
$string['core.contentlinks.confirmurlothersite'] = 'Este enlace pertenece a otro sitio. ¿Quieres abrirlo?';
$string['core.contentlinks.errornoactions'] = 'No se ha encontrado ninguna acción para realizar con este enlace.';
$string['core.contentlinks.errornosites'] = 'No se ha encontrado ningún sitio para gestionar este enlace.';
$string['core.copiedtoclipboard'] = 'Texto copiado al portapapeles';
$string['core.course.activitydisabled'] = 'Su  organización ha deshabilitado esta actividad en la aplicación móvil.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Esta actividad es un complemento de terceros que todavía no está soportada por la aplicación.';
$string['core.course.activitynotyetviewablesiteupgradeneeded'] = 'El sitio no está usando la versión más reciente de Moodle. Por favor, contacte al administrador del sitio.';
$string['core.course.allsections'] = 'Todas las secciones';
$string['core.course.askadmintosupport'] = 'Contacte al administrador del sitio e indíquele que desea poder usar esta actividad en la aplicación.';
$string['core.course.confirmdeletemodulefiles'] = '¿Está seguro de querer eliminar estos archivos del módulo?';
$string['core.course.confirmdownload'] = 'Está a punto de descargar {{size}}. ¿Está seguro de que desea continuar?';
$string['core.course.confirmdownloadunknownsize'] = 'No se puede calcular el tamaño de la descarga. ¿Está seguro que quiere descargarlo?';
$string['core.course.confirmpartialdownloadsize'] = 'Está a punto de descargar <strong>al menos</strong> {{size}}. ¿Está seguro de querer continuar?';
$string['core.course.contents'] = 'Contenidos';
$string['core.course.couldnotloadsectioncontent'] = 'No se ha podido cargar el contenido de la sección, por favor inténtelo más tarde.';
$string['core.course.couldnotloadsections'] = 'No se ha podido cargar las secciones, por favor inténtelo más tarde.';
$string['core.course.errordownloadingcourse'] = 'Error al descargar el curso.';
$string['core.course.errordownloadingsection'] = 'Error durante la descarga de la sección.';
$string['core.course.errorgetmodule'] = 'Se ha producido un error recuperando los datos del módulo.';
$string['core.course.nocontentavailable'] = 'No hay contenido disponible en este momento.';
$string['core.course.refreshcourse'] = 'Refrescar curso';
$string['core.courses.cannotretrievemorecategories'] = 'No se pueden recuperar categorías más profundas que el nivel {{$a}}.';
$string['core.courses.confirmselfenrol'] = '¿Está seguro que desea auto-matricularse en este curso?';
$string['core.courses.downloadcourses'] = 'Descargar cursos';
$string['core.courses.enrolme'] = 'Matricularme';
$string['core.courses.errorloadcategories'] = 'Ocurrió un error al cargar categorías.';
$string['core.courses.errorloadcourses'] = 'Se ha producido un error cargando los cursos.';
$string['core.courses.errorsearching'] = 'Se ha producido un error durante la búsqueda.';
$string['core.courses.errorselfenrol'] = 'Se ha producido un error durante la auto-matriculación.';
$string['core.courses.filtermycourses'] = 'Filtrar mis cursos';
$string['core.courses.notenrollable'] = 'No puede auto-matricularse en este curso.';
$string['core.courses.password'] = 'Clave';
$string['core.courses.searchcoursesadvice'] = 'Puede utilizar el botón de buscar cursos para acceder como invitado o auto-matricularse en los cursos que lo permitan.';
$string['core.courses.selfenrolment'] = 'Auto-matriculación';
$string['core.courses.totalcoursesearchresults'] = 'Total de cursos: {{$a}}';
$string['core.course.useactivityonbrowser'] = 'Puede acceder a esta actividad mediante el navegador de su dispositivo.';
$string['core.currentdevice'] = 'Dispositivo actual';
$string['core.datastoredoffline'] = 'Los datos se almacenaron en el dispositivo debido a que no se pudieron enviar. Serán enviados automáticamente más tarde.';
$string['core.deletedoffline'] = 'Eliminado fuera de línea';
$string['core.deleting'] = 'Borrando';
$string['core.dfdaymonthyear'] = 'MM-DD-YYYY';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = 'Descartar';
$string['core.dismiss'] = 'Descartar';
$string['core.downloading'] = 'Descargando...';
$string['core.emptysplit'] = 'Esta página aparecerá en blanco si el panel izquierdo está vacío o si está cargando.';
$string['core.errorchangecompletion'] = 'Ha ocurrido un error cargando el grado de realización. Por favor inténtalo de nuevo.';
$string['core.errordeletefile'] = 'Error al eliminar el archivo. Por favor inténtelo de nuevo.';
$string['core.errordownloading'] = 'Ocurrió un error descargando el archivo';
$string['core.errordownloadingsomefiles'] = 'Se ha producido un error descargando los ficheros del módulo. Algunos archivos se pueden haber perdido.';
$string['core.errorfileexistssamename'] = 'Ya existe un archivo con este nombre.';
$string['core.errorinvalidform'] = 'El formulario contiene datos inválidos. Por favor, asegúrese de rellenar todos los campos requeridos y que los datos son válidos.';
$string['core.errorinvalidresponse'] = 'Se ha recibido una respuesta no válida. Por favor contactar con el administrador de Moodle si el error persiste.';
$string['core.errorloadingcontent'] = 'Error cargando contenido.';
$string['core.errorofflinedisabled'] = 'La navegación fuera de línea está deshabilitada en su sitio. Necesita estar conectado a Internet para usar la aplicación.';
$string['core.erroropenfilenoapp'] = 'Error durante la apertura del archivo: no se encontró ninguna aplicación capaz de abrir este tipo de archivo.';
$string['core.erroropenfilenoextension'] = 'Se ha producido un error abriendo el archivo: el archivo no tiene extensión.';
$string['core.erroropenpopup'] = 'Esta actividad está intentando abrir una ventana emergente. Esta aplicación no lo soporta.';
$string['core.errorrenamefile'] = 'Error al renombrar el archivo. Por favor inténtelo de nuevo.';
$string['core.errorsync'] = 'Ocurrió un error al sincronizar. Por favor inténtelo de nuevo más tarde.';
$string['core.errorsyncblocked'] = 'Este/a {{$a}} no puede sincronizarse ahora mismo porque hay un proceso trabajando. Por favor inténtelo de nuevo más tarde. Si el problema persiste, intente reiniciar la aplicación.';
$string['core.filenameexist'] = 'El nombre de archivo ya existe: {{$a}}';
$string['core.fileuploader.audio'] = 'Audio';
$string['core.fileuploader.camera'] = 'Cámara';
$string['core.fileuploader.confirmuploadfile'] = 'Usted va a subir {{size}}. ¿Desea continuar?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'No pudimos calcular el tamaño de la subida. ¿Está seguro de querer continuar?';
$string['core.fileuploader.errorcapturingaudio'] = 'Error capturando audio';
$string['core.fileuploader.errorcapturingimage'] = 'Error capturando imagen.';
$string['core.fileuploader.errorcapturingvideo'] = 'Error grabando el vídeo';
$string['core.fileuploader.errorgettingimagealbum'] = 'Error tomando la imagen desde al álbum.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Debe estar conectado para subir archivos.';
$string['core.fileuploader.errornoapp'] = 'Usted no tiene una app instalada para realizar esta acción.';
$string['core.fileuploader.errorreadingfile'] = 'Error al leer el archivo  "{$a}"';
$string['core.fileuploader.errorwhileuploading'] = 'Ocurrió un error al subir un archivo.';
$string['core.fileuploader.file'] = 'Archivo';
$string['core.fileuploader.fileuploaded'] = 'Archivo subido';
$string['core.fileuploader.maxbytesfile'] = 'El archivo {{$a.file}} es demasido grande. El tamaño máximo que puede subir es {{$a.size}}.';
$string['core.fileuploader.photoalbums'] = 'Álbumes de fotos';
$string['core.fileuploader.readingfile'] = 'Leyendo archivo';
$string['core.fileuploader.selectafile'] = 'Seleccionar un archivo';
$string['core.fileuploader.uploadafile'] = 'Subir un archivo';
$string['core.fileuploader.uploading'] = 'Subiendo';
$string['core.fileuploader.uploadingperc'] = 'Subiendo: {{$a}}%';
$string['core.fileuploader.video'] = 'Vídeo';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.hasdatatosync'] = 'Este/a {{$a}} tiene datos fuera de línea para sincronizarse.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.image'] = 'Imagen';
$string['core.imageviewer'] = 'Visor de imágenes';
$string['core.ios'] = 'iOs';
$string['core.lastdownloaded'] = 'Última descarga';
$string['core.lastsync'] = 'Última sincronización';
$string['core.loadmore'] = 'Cargar más';
$string['core.login.authenticating'] = 'Autenticando';
$string['core.login.checksiteversion'] = 'Comprueba que tu sitio utiliza Moodle 2.4 o superior.';
$string['core.login.confirmdeletesite'] = '¿Está seguro de que quiere eliminar el sitio {{sitename}}?';
$string['core.login.connect'] = 'Conectar';
$string['core.login.connecttomoodle'] = 'Conectar a Moodle';
$string['core.login.contactyouradministrator'] = 'Contacte a su administrador del sitio para más ayuda.';
$string['core.login.contactyouradministratorissue'] = 'Por favor, pídale al administrador que revise el siguiente problema: {{$a}}';
$string['core.login.credentialsdescription'] = 'Introduzca su nombre se usuario y contraseña para entrar';
$string['core.login.emailnotmatch'] = 'Las direcciones de correo no coinciden.';
$string['core.login.erroraccesscontrolalloworigin'] = 'La llamada Cross-Origin que está intentando ha sido rechazada. Por favor visite https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['core.login.errordeletesite'] = 'Ha ocurrido un error eliminando este sitio. Por favor, inténtelo de nuevo.';
$string['core.login.errorupdatesite'] = 'Se ha producido un error actualizando el token del sitio.';
$string['core.login.helpmelogin'] = '<p>Existen muchos sitios Moodle en el mundo. Esta aplicación solamente puede conectar a sitios Moodle que tengan específicamente habilitado el acceso por la aplicación Moodle.</p><p>Si no puede conectarse a su sitio Moodle, póngase en contacto con el administrador del sitio y pídale que lea <a href="http://docs.moodle.org/es/Mobile_app" target="_blank">http://docs.moodle.org/es/Mobile_app</a></p><p>Para probar la aplicación en un sitio Moodle de muestra, escriba <i>teacher</i> o <i>student</i> en el campo de la <i>Dirección del sitio</i> y haga click en el <b>Botón Conectar</b>.</p>';
$string['core.login.invalidaccount'] = 'Por favor, verifique sus datos de acceso, o consulte con el administrador para revisar la configuración del sitio.';
$string['core.login.invalidmoodleversion'] = 'Versión de Moodle inválida. La versión mínima requerida es 2.4.';
$string['core.login.invalidsite'] = 'La URL del sitio es inválida.';
$string['core.login.invalidtime'] = 'Hora incorrecta';
$string['core.login.invalidvaluemax'] = 'El valor máximo es {{$a}}';
$string['core.login.invalidvaluemin'] = 'El valor mínimo es {{$a}}';
$string['core.login.legacymoodleversion'] = 'Está tratando de conectarse a una versión de Moodle no soportada. Por favor, descargue la aplicación de Moodle Classic para acceder a este sitio Moodle.';
$string['core.login.legacymoodleversiondesktop'] = 'Está intentando conectarse a <b>{{$a}}</b>.<br><br>Este sitio está ejecutando una versión antigua no soportada de Moodle, la cual no funcionará con esta aplicación de Moodle Desktop.<br><br>Si este es su sitio, por favor póngase en contacto con su Moodle Partner local para obtener asistencia para actualizarlo.<br><br>Vea <a href="https://moodle.com/contact">nuestra página de contacto</a> para solicitar asistencia.';
$string['core.login.localmobileunexpectedresponse'] = 'Las características adicionales de Moodle Mobile han devuelto una respuesta inesperada, debe autenticarse utilizando el servicio estándar de Mobile.';
$string['core.login.loggedoutssodescription'] = 'Tiene que autenticarse nuevamente. Necesita acceder al sitio en una ventana del navegador.';
$string['core.login.loginbutton'] = 'Acceder';
$string['core.login.logininsiterequired'] = 'Para autentificarse en el sitio se ha de abrir una ventana de navegador.';
$string['core.login.mobileservicesnotenabled'] = 'El acceso móvil no está habilitado para este sitio, por favor, contacte con su administrador si piensa que debería estar habilitado.';
$string['core.login.newsitedescription'] = 'Introduzca la URL de su sitio Moodle. Tenga en cuenta que podría no estar configurado para trabajar con esta aplicación.';
$string['core.login.notloggedin'] = 'Ha de entrar al sitio.';
$string['core.login.passwordrequired'] = 'Contraseña obligatoria';
$string['core.login.problemconnectingerror'] = 'Estamos teniendo dificultades para conectar con su sitio';
$string['core.login.problemconnectingerrorcontinue'] = 'Compruebe de nuevo que ha introducido correctamente la dirección del sitio.';
$string['core.login.recaptchachallengeimage'] = 'reto reCAPTCHA';
$string['core.login.recaptchaexpired'] = 'La verificación ha expirado. Contesta nuevamente la pregunta de seguridad.';
$string['core.login.recaptchaincorrect'] = 'La respuesta a la pregunta de seguridad es incorrecta.';
$string['core.login.reconnect'] = 'Reconectar';
$string['core.login.reconnectdescription'] = 'El token de autenticación no es válido o ha caducado, ha de volver a conectarse al sitio.';
$string['core.login.reconnectssodescription'] = 'El token de autenticación no es válido o ha caducado, ha de volver a conectarse al sitio. Necesita hacerlo desde un navegador web.';
$string['core.login.searchby'] = 'Buscar por:';
$string['core.login.selectsite'] = 'Por favor seleccione su sitio:';
$string['core.login.signupplugindisabled'] = '{{$a}} no está habilitado';
$string['core.login.siteaddress'] = 'Dirección del sitio';
$string['core.login.siteinmaintenance'] = 'Su sitio está en modo mantenimiento';
$string['core.login.sitepolicynotagreederror'] = 'No se aceptó la política del sitio.';
$string['core.login.siteurl'] = 'URL del sitio';
$string['core.login.siteurlrequired'] = 'La URL del sitio es obligatoria, por ejemplo <i>http://www.yourmoodlesite.es o  https://www.yourmoodlesite.org</i>';
$string['core.login.stillcantconnect'] = '¿Todavía no puede conectar?';
$string['core.login.usernamerequired'] = 'Nombre de usuario obligatorio';
$string['core.login.visitchangepassword'] = '¿Quiere visitar el sitio para cambiar la contraseña?';
$string['core.login.webservicesnotenabled'] = 'Los Servicios Web no están habilitados en su sitio, por favor, contacte con su administrador de Moodle si piensa que deberían estarlo.';
$string['core.lostconnection'] = 'Hemos perdido la conexión, necesita reconectar. Su token ya no es válido';
$string['core.mainmenu.appsettings'] = 'Configuración de la aplicación';
$string['core.mainmenu.changesite'] = 'Cambiar de sitio';
$string['core.mainmenu.website'] = 'Página web';
$string['core.networkerrormsg'] = 'Conexión no disponible o sin funcionar.';
$string['core.nopasswordchangeforced'] = 'No puede continuar sin cambiar su contraseña.';
$string['core.notapplicable'] = 'n/a';
$string['core.notsent'] = 'No enviado';
$string['core.openfullimage'] = 'Haga clic aquí para ver la imagen a tamaño completo';
$string['core.openinbrowser'] = 'Abrir en el navegador';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.pulltorefresh'] = 'Tirar para recargar';
$string['core.question.errorattachmentsnotsupported'] = 'La aplicación no soporta adjuntar archivos a respuestas todavía.';
$string['core.question.errorinlinefilesnotsupported'] = 'La aplicación aun no soporta el editar archivos en-línea.';
$string['core.question.errorquestionnotsupported'] = 'Este tipo de pregunta no está soportada por la aplicación: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Tocar para seleccionar y tocar para soltar.';
$string['core.question.questionmessage'] = 'Pregunta {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Será redirigido al sitio.';
$string['core.requireduserdatamissing'] = 'En este perfil de usuario faltan datos requeridos. Por favor, rellene estos datos e inténtelo otra vez.<br>{{$a}}';
$string['core.retry'] = 'Reintentar';
$string['core.searching'] = 'Buscando';
$string['core.settings.about'] = 'Acerca de';
$string['core.settings.appready'] = 'App preparada';
$string['core.settings.cannotsyncoffline'] = 'No puede sincronizarse fuera de línea.';
$string['core.settings.cannotsyncwithoutwifi'] = 'No puede sincronizarse porque las configuraciones actuales solamente permiten sincronizar cuando está conectado a Wi-Fi. Por favor, conéctese a una red Wi-Fi.';
$string['core.settings.compilationinfo'] = 'Información de compilación';
$string['core.settings.cordovadevicemodel'] = 'Modelo de dispositivo Cordova';
$string['core.settings.cordovadeviceosversion'] = 'Versión de OS de dispositivo Cordova';
$string['core.settings.cordovadeviceplatform'] = 'Plataforma de dispositivo Cordova';
$string['core.settings.cordovadeviceuuid'] = 'uuid del dispositivo Cordova';
$string['core.settings.cordovaversion'] = 'Versión Cordova';
$string['core.settings.deletesitefiles'] = '¿Está seguro de que desea borrar todos los archivos descargados de este sitio?';
$string['core.settings.deletesitefilestitle'] = 'Elimina los ficheros del sitio';
$string['core.settings.deviceinfo'] = 'Información del dispositivo';
$string['core.settings.deviceos'] = 'OS del dispositivo';
$string['core.settings.devicewebworkers'] = 'Soporta Device Web Workers';
$string['core.settings.displayformat'] = 'Formato de visualización';
$string['core.settings.enabledownloadsection'] = 'Habilitar la descarga de secciones';
$string['core.settings.enablerichtexteditor'] = 'Activar editor de texto enriquecido';
$string['core.settings.enablerichtexteditordescription'] = 'Si se habilita, se mostrará un editor de texto enriquecido en los lugares que lo permitan.';
$string['core.settings.enablesyncwifi'] = 'Permitir la sincronización solo con la WiFi activada';
$string['core.settings.errordeletesitefiles'] = 'Se ha producido un error eliminando los ficheros del sitio.';
$string['core.settings.errorsyncsite'] = 'Se ha producido un error sincronizando los datos del sitio, por favor compruebe su conexión a internet y pruebe de nuevo.';
$string['core.settings.estimatedfreespace'] = 'Espacio libre (estimado)';
$string['core.settings.filesystemroot'] = 'Raíz del sistema de archivos';
$string['core.settings.localnotifavailable'] = 'Notificaciones locales disponibles';
$string['core.settings.locationhref'] = 'Webview URL';
$string['core.settings.navigatorlanguage'] = 'Lenguaje del navegador';
$string['core.settings.navigatoruseragent'] = 'Agente de usuario del navegador';
$string['core.settings.networkstatus'] = 'Estado de la conexión a internet';
$string['core.settings.privacypolicy'] = 'Política de privacidad.';
$string['core.settings.reportinbackground'] = 'Informar de los errores automáticamente';
$string['core.settings.spaceusage'] = 'Espacio';
$string['core.settings.synchronization'] = 'Sincronización';
$string['core.settings.synchronizenow'] = 'Sincronizar ahora';
$string['core.settings.syncsettings'] = 'Configuración de la sincronización';
$string['core.settings.versioncode'] = 'Código de la versión';
$string['core.settings.versionname'] = 'Nombre de la versión';
$string['core.settings.wificonnection'] = 'Conexión WiFi';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Elija una cuenta en la cual almacenar el archivo.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Ya existe un archivo con este nombre. ¿Desea usted remplazar el archivo existente o renombrarlo a  "{{$a}}"?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'No hay sitios almacenados. Por favor, añada un sitio antes de compartir un archivo con la aplicación.';
$string['core.sharedfiles.nosharedfiles'] = 'No hay archivos compartidos en este sitio.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'No tiene archivos para subir aquí. Si desea subir un archivo desde otra aplicación, localice ese archivo y haga clic en el botón para \'Abrir en\'.';
$string['core.sharedfiles.rename'] = 'Renombrar';
$string['core.sharedfiles.replace'] = 'Reemplazar';
$string['core.sharedfiles.sharedfiles'] = 'Archivos compartidos';
$string['core.sharedfiles.successstorefile'] = 'Archivo almacenado correctamente. Ahora puede seleccionar este archivo para subirlo a sus archivos privados, o adjuntarlo a algunas actividades.';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Disculpe...';
$string['core.tablet'] = 'Tablet';
$string['core.thereisdatatosync'] = 'Hay {{$a}} fuera de línea pendiente de ser sincronizado.';
$string['core.tryagain'] = 'Intentar de nuevo';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = '¡Oh oh!';
$string['core.unexpectederror'] = 'Error inesperado. Por favor cierre y vuelva a abrir la aplicación para intentarlo de nuevo';
$string['core.unicodenotsupported'] = 'Los emojis no están soportado en este sitio; esos caracteres serán quitados cuando el mensaje sea enviado.';
$string['core.unicodenotsupportedcleanerror'] = 'Se encontró texto vacío al limpiar caracteres Unicode.';
$string['core.unknown'] = 'Desconocido';
$string['core.unzipping'] = 'Descomprimiendo';
$string['core.user.contact'] = 'Contacto';
$string['core.user.detailsnotavailable'] = 'No tiene acceso a los detalles de este usuario.';
$string['core.user.errorloaduser'] = 'Error cargando el usuario.';
$string['core.user.sendemail'] = 'Correo electrónico';
$string['core.viewcode'] = 'Ver código';
$string['core.vieweditor'] = 'Ver editor';
$string['core.warningofflinedatadeleted'] = 'Los datos fuera de línea de {{component}} \'{{name}}\' han sido borrados. {{error}}';
$string['core.whoops'] = 'Oops!';
$string['core.whyisthishappening'] = '¿Porqué está pasando esto?';
$string['core.windowsphone'] = 'Windows Phone';
$string['core.wsfunctionnotavailable'] = 'La función de webservice no está disponible.';
$string['pluginname'] = 'Cadenas de idioma de Moodle Mobile';
