<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodleorg', language 'es', branch 'MOODLE_26_STABLE'
 *
 * @package   local_moodleorg
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutstatistics'] = 'La descarga de Moodle es gratuita y el registro volutario por lo que no tenemos información de todo el mundo que lo usa. De todas formas, utilizando lo que sabemos, automáticamente generamos gráficos e información estadística en nuestra página de estadísticas.';
$string['aboutstatisticsheading'] = 'Estadísticas de Moodle';
$string['aboutstatisticstitle'] = 'Moodle.org: Estadísticas de Moodle';
$string['activeusers24hours'] = 'Usuarios registrados que han accedido las últimas 24 horas:';
$string['activeuserspastmonth'] = 'Usuarios registrados que han accedido el pasado mes:';
$string['browsegittitle'] = 'Navega nuestro código fuente';
$string['cachedef_frontpagecolumn'] = 'Columnas de portada';
$string['cachedef_usefulposts'] = 'Mensajes útiles';
$string['communities'] = 'Comunidades';
$string['communitiesmy'] = 'Mis comunidades';
$string['community'] = 'Comunidad';
$string['communityadministration'] = 'Administración de la comunidad';
$string['communitycurrent'] = 'Comunidad actual';
$string['communityenrolme'] = 'Hazte miembro de esta comunidad';
$string['communityenrolmentoptions'] = 'Unirse a una comunidad';
$string['communityintro'] = 'Moodle tiene una gran y diversa comunidad de usuarios con alrededor de <a href="http://moodle.org/userpics">{$a->usercount} usuarios registrados</a> sólamente en este sitio Moodle, hablando más <a href="http://download.moodle.org/lang16/">{$a->langcount} idiomas</a> en <a href="http://moodle.org/sites">{$a->countrycount} países</a> (disponemos de <a href="http://moodle.org/stats">más estadísticas</a>).';
$string['communityjoinbyyourself'] = 'Únase usted mismo';
$string['communityjoinbyyourselfas'] = 'Únase usted mismo como {$a->rolename}';
$string['communitynoguestaccess'] = 'Los invitados no pueden acceder a esta área de la comunidad, por favor, trate de acceder con su usuario.';
$string['communitynotenrollable'] = 'Usted mismo no puede convertirse en miembro de esta comunidad. Por favor, contacte con el moderador de la comunidad.';
$string['communitysomeallowguest'] = 'Algunas comunidades pueden permitir el acceso a invitados';
$string['communityunenrolme'] = 'Abandonar la comunidad {$a}';
$string['conferencecenter'] = 'Centro de conferencias de Moodle';
$string['connectedsites'] = 'Algunos sitios Moodle se han conectado a moodle.org usando la red de Moodle, por lo que puede acceder directamente a ellas una vez se haya autenticado aquí.';
$string['donations'] = 'Moodle está completamente libre de obligaciones económicas, no obstante muchos miembros de la comunidad han realizado donaciones para ayudar a los desarrolladores que hacen Moodle posible.';
$string['donationsmoney'] = 'Puede contribuir con dinero directamente al fondo a través de una donación en efectivo. Todo este dinero se utiliza para convertir en realidad  los deseos de nuestra hoja de ruta y que todos podamos disfrutarlos. Para hacer una donación con tarjeta de crédito en la mayoría de las principales monedas, por favor haga clic en el botón inferior de Paypal. <br /> <br /> Los donantes de más de $10 añadirán su nombre a esta página durante un año. Por favor, recuerde pulsar el botón "Continuar" después de pagar para ver el formulario donde podrá editar la manera en que  referencia aparecerá,';
$string['donationsservices'] = 'Si usted tiene necesidad de servicios de Moodle, tales como como hosting, soporte, instalación, programación personalizada, desarrollo de cursos o asesoría, por favor contacte con su distribuidor autorizado <a href="http://moodle.com/"> Moodle Partner de moodle.com </ a> (puede encontrar sus anuncios publicitarios en este sitio). Los socios aportan un porcentaje fijo de todos sus ingresos para el fondo fiduciario de desarrollo de Moodle, por lo que todo el mundo gana.';
$string['donationstitle'] = 'Donaciones';
$string['donationstrust'] = 'Moodle tiene un fondo de desarrollo mantenido por el Moodle Trust, que contrata a programadores para trabajar en Moodle, y sufraga asimismo gastos como moodle.org';
$string['downloadcore'] = 'Nuestro principal método de distribución es a través de estos paquetes estándar con la distribución base. Contienen un conjunto de módulos que son mantenidos por los desarrolladores de Moodle, y son adecuados para ser utilizados en cualquier plataforma donde tenga instalados PHP y una base de datos.';
$string['downloadcoretitle'] = 'Paquetes estándar de Moodle';
$string['downloadintro'] = 'Moodle es código abierto bajo <a href="http://docs.moodle.org/dev/License">GPL licence</a>.  Todo lo que creamos se puede descargar y utilizar gratuita y libremente.';
$string['downloadlang'] = 'En las versiones actuales de Moodle se ha automatizado la adición de paquetes de idiomas desde el menú de administración del sitio. De todas formas, para versiones antiguas de Moodle, los paquetes de idioma se pueden descargar de forma manual.';
$string['downloadlangtitle'] = 'Paquetes de idioma';
$string['downloadmac'] = 'Si aún no dispone de un servidor web, estos paquetes con todo incluido le ayudarán a instalar de forma fácil Moodle en cualquier ordenador con Mac OS X.';
$string['downloadmactitle'] = 'Moodle para Mac OS X';
$string['downloadmodules'] = 'Navegue por nuestra base de datos de módulos extra y extensiones que pueden ser instalados en su sitio Moodle para dotarlo de funcionalidades extras más allá de las incluidas en la distribución base de Moodle.';
$string['downloadmodulestitle'] = 'Extensiones';
$string['downloadthemes'] = 'El aspecto visual de Moodle puede cambiar notablemente en función del tema gráfico.  Mantenemos una base de datos de temas creados y mantenidos por usuarios de Moodle.';
$string['downloadthemestitle'] = 'Temas';
$string['downloadviagitcvs'] = 'Otras formas de obtener Moodle incluyen <a href="http://docs.moodle.org/all/es/Git_para_Administradores">descarga mediante Git</a> o <a href="http://docs.moodle.org/22/en/CVS_for_Administrators">descarga mediante CVS</a>.';
$string['downloadwin'] = 'Si aún no dispone de un servidor web, estos paquetes con todo incluido le ayudarán a instalar de forma fácil Moodle en cualquier ordenador con Microsoft Windows.';
$string['downloadwintitle'] = 'Moodle para Windows';
$string['erroradminonly'] = 'Únicamente los administradores pueden acceder a esta interfaz.';
$string['erroralreadyvoted'] = 'Usted ya ha votado por {$a}';
$string['errormaxmessages'] = 'Lo sentimos, pero no puede enviar más de 3 mensajes.';
$string['errornomainnews'] = 'No se ha podido encontrar o crear un foro principal de noticias en el sitio';
$string['errorsendingmail'] = 'Ha ocurrido un error al enviar el mensaje. Por favor, inténtelo de nuevo más tarde, o contacte con el administrador del sitio.';
$string['events'] = 'Aunque estamos especializados en la enseñanza en línea, siempre es bueno verse todos juntos en persona. Visite estos enlaces para más información sobre nuestras conferencias (las llamamos MoodleMoots) y otros eventos.';
$string['eventstitle'] = 'Eventos';
$string['feed_events'] = 'Eventos';
$string['feed_events_more'] = 'Más entradas del calendario';
$string['feed_news'] = 'Anuncios';
$string['feed_news_more'] = 'Ver todos los anuncios';
$string['feed_resources'] = 'Recursos';
$string['feed_useful'] = 'Mensajes útiles';
$string['feed_useful_more'] = 'Más mensajes';
$string['focusbox_community'] = 'Soporte y foros de la comunidad';
$string['focusbox_community_text'] = 'Obtenga soporte y comparta ideas, en su propio idioma.';
$string['focusbox_community_viewall'] = 'Listar todas las comunidades';
$string['focusbox_future'] = 'Ayude a darle forma al futuro de Moodle';
$string['focusbox_future_crowdfund'] = 'Proyectos financiados por la comunidad';
$string['focusbox_future_gdf'] = 'Foros de desarrolladores';
$string['focusbox_future_research'] = 'Investigación Moodle';
$string['focusbox_future_roadmap'] = 'Plan de desarrollo';
$string['focusbox_future_text'] = 'Descubre qué es lo próximo y ayude a marcar la diferencia.';
$string['focusbox_settingup'] = 'Configuración';
$string['focusbox_settingup_community'] = 'Soporte de la comunidad';
$string['focusbox_settingup_download'] = 'Descarga gratuita';
$string['focusbox_settingup_hosting'] = 'Alojamiento';
$string['focusbox_settingup_install'] = 'Instalación';
$string['focusbox_settingup_own'] = 'Por sí mismo';
$string['focusbox_settingup_partner'] = 'A través de un Moodle Partner';
$string['focusbox_settingup_support'] = 'Soporte comercial';
$string['focusbox_teaching'] = 'Enseñando con Moodle';
$string['focusbox_teaching_books'] = 'Libros';
$string['focusbox_teaching_courses'] = 'Cursos y contenido';
$string['focusbox_teaching_docs'] = 'Documentación';
$string['focusbox_teaching_text'] = 'Explore la gran variedad de funcionalidades y recursos disponibles en Moodle.';
$string['focusbox_theproject'] = 'El proyecto Moodle';
$string['focusbox_theproject_about'] = 'Acerca de Moodle';
$string['focusbox_theproject_devs'] = 'Desarrolladores';
$string['focusbox_theproject_hq'] = 'Sede central de Moodle';
$string['focusbox_theproject_stats'] = 'Estadísticas';
$string['focusbox_theproject_text'] = 'Aprenda más sobre el proyecto Moodle y nuestros acuerdos de colaboración.';
$string['focusbox_uptodate'] = 'Manténgase actualizado';
$string['focusbox_uptodate_planet'] = 'Planeta Moodle';
$string['focusbox_uptodate_security'] = 'Avisos de seguridad';
$string['focusbox_uptodate_social'] = 'Redes sociales';
$string['focusbox_uptodate_text'] = 'Últimas noticias sobre Moodle, actualizaciones y destacados en el mundo.';
$string['generaldeveloperforum'] = 'Foro general de desarrolladores';
$string['graphpopulation'] = 'Gráfico de la población de Moodle';
$string['graphregistrationmap'] = 'Mapa de registros de Moodle';
$string['graphregistrationmapdesc'] = 'Los 10 primeros entre los sitios registrados en {$a} países';
$string['graphusersites'] = 'Comparación de usuarios de Moodle v sitio';
$string['heroslide_community_description'] = 'Bienvenido a la comunidad Moodle. Descubra el valor de un esfuerzo abierto colaborativo por uno de los equipos de código abierto más grandes del mundo.';
$string['heroslide_community_headline'] = 'Impulsado por la comunidad, soportado globalmente.';
$string['heroslide_global_description'] = 'Disponible en más de 100 idiomas, Moodle tiene la confianza de organizaciones e instituciones, grandes y pequeñas, con millones de usuarios en todo el mundo.';
$string['heroslide_global_headline'] = 'Impulsando ambientes de aprendizaje en todo el mundo';
$string['heroslide_global_slidecontrol'] = 'Impulsando ambientes de aprendizaje en todo el mundo';
$string['heroslide_link_demo'] = 'Demostración';
$string['heroslide_link_features'] = 'Características';
$string['heroslide_link_forums'] = 'Foros de la comunidad';
$string['heroslide_link_sites'] = 'Sitios registrados';
$string['heroslide_link_stats'] = 'Estadísticas';
$string['heroslide_link_stories'] = 'Leer más';
$string['heroslide_power_headline'] = 'Poderoso. Seguro. Código abierto.';
$string['heroslide_power_slidecontrol'] = 'Sólida plataforma de aprendizaje de código abierto';
$string['heroslide_story_description'] = '"Al ser líder en el aprendizaje apoyado en la tecnología, nos permite fomentar en los estudiantes la curiosidad, la creatividad y la búsqueda de oportunidades."- Profesor Darrell Evans, Vicerrector (Aprendizaje y Enseñanza), Universidad Monash';
$string['heroslide_story_headline'] = 'Mejorando la enseñanza y el aprendizaje en todas partes';
$string['heroslide_story_slidecontrol'] = 'Historias sobre Moodle alrededor del mundo';
$string['jobs'] = 'Visite nuestra base de datos de ofertas de trabajo para información sobre puestos de trabajo en todo el mundo';
$string['logotitle'] = 'Logo de Moodle';
$string['moodlepartner_corporate'] = 'Entrenamiento corporativo';
$string['moodlepartner_other'] = 'Otros sectores';
$string['moodlepartner_school'] = 'Escuela';
$string['moodlepartner_university'] = 'Universidad';
$string['networkinfo'] = 'Los siguientes sitios Moodle han sido conectados a moodle.org empleando la red Moodle, por lo que puede ingresar a ellos directamente desde aquí.';
$string['networktitle'] = 'Sitios conectados';
$string['newregistrations'] = 'Registros nuevos';
$string['newstitle'] = 'Noticias';
$string['noenrolledcoursesyet'] = 'Aún no se ha matriculado en ningún curso de este sitio';
$string['permalink'] = 'Enlace  permanente';
$string['pluginname'] = 'Sitio moodle.org';
$string['popularissues'] = 'Temas más populares';
$string['recentpart'] = 'Esta página muestra algunas de las personas que están utilizando moodle.org hoy.';
$string['registeredsites'] = 'Las instituciones no están obligadas a informar a nadie cuando usan Moodle, porque Moodle es Código Abierto.  Aún así, algunos sitios Moodle han escogido registrarse con nosotros y así los podemos listar.';
$string['registeredsitestitle'] = 'Sitios registrados';
$string['registereduserslastday'] = 'Nuevos usuarios en las últimas 24 horas:';
$string['registereduserstotal'] = 'Total de usuarios registrados:';
$string['registrationgraphalt'] = 'Registros totales en Moodle a lo largo del tiempo';
$string['registrationgraphdesc'] = 'Llevamos a cabo una <a href="http://docs.moodle.org/en/Usage">comprobación masiva regular de los sitios </a> para asegurarnos de que aún existen, por lo que en ocasiones es posible que vea reducciones en el recuento';
$string['registrationslast6months'] = 'Registros en los últimos 6 meses';
$string['registrationstotal'] = 'Todos los registros actuales';
$string['resources_courses'] = 'Cursos';
$string['resources_jobs'] = 'Empleos';
$string['roadmap'] = 'Hoja de ruta de Moodle';
$string['searchmoodleorg'] = 'Buscar moodle.org';
$string['securitytitle'] = 'Anuncios de seguridad';
$string['shop'] = '¿Busca la forma de hacer ver que forma parte de nuestra comunidad? Eche un ojo a nuestra tienda donde encontrará camisetas, tazas y otras cosas.';
$string['social-facebook-moodle'] = 'Página oficial de Moodle en Facebook';
$string['social-googleplus-community'] = 'Página oficial de comunidad Moodle en Google+';
$string['social-googleplus-moodle'] = 'Página oficial de Moodle en Google+';
$string['social-linkedin-moodle'] = 'Página oficial de Moodle en Linkedln';
$string['socialtitle'] = 'Medios sociales';
$string['social-twitter-moodledev'] = 'Actualizaciones y noticias sobre el desarrollo de Moodle';
$string['social-twitter-moodlehq'] = 'Tweets de Moodle HQ';
$string['social-twitter-moodlenet'] = 'Contenido y cursos compartidos de Moodle';
$string['social-twitter-moodleplugins'] = 'Extensiones de Moodle publicadas recientemente';
$string['social-twitter-moodlesecurity'] = 'Avisos de seguridad de Moodle';
$string['social-youtube-moodle'] = 'Canal oficial de Moodle en YouTube';
$string['statscountries'] = 'Países';
$string['statscourses'] = 'Cursos';
$string['statsenrolments'] = 'Matriculaciones';
$string['statsposts'] = 'Mensajes en foros';
$string['statsquestions'] = 'Preguntas de cuestionario';
$string['statsresources'] = 'Recursos';
$string['statsteachers'] = 'Profesores';
$string['statsusers'] = 'Usuarios';
$string['supportbooks'] = 'Mantenemos una lista de libros a la venta sobre Moodle.';
$string['supportcommercial'] = 'Los <a href="http://moodle.com/">Partners de Moodle</a> son un grupo de empresas que prestan servicios autorizados por todo el mundo encargados de financiar económicamente el proyecto de código abierto Moodle. Proporcionan una gran variedad de servicios comerciales para los usuarios de Moodle en todo el mundo:';
$string['supportdocs1'] = 'La documentación de Moodle es un buen sitio para empezar, sobre todo nuestra página de Preguntas Frecuentes.';
$string['supportdocs2'] = 'Una buena manera de acceder a documentación relevante de Moodle es utilizar el enlace "Documentación de Moodle para esta página" en la parte inferior de cada página de su sitio Moodle.';
$string['supportdocsfaq'] = 'Preguntas frecuentes';
$string['supportdocslang'] = 'Documentación de Moodle en otros idiomas';
$string['supportforums'] = 'Nuestra comunidad de usuarios se comunica principalmente mediante los foros dentro de los "cursos" de este sitio Moodle.  Debe "matricularte" en el curso para poder enviar mensajes (la matriculación es totalmente gratuita).';
$string['supportforumsenglish'] = 'Aquí la mayoría del soporte y debates entre usuarios y desarrolladores están en inglés:';
$string['supportforumsenglishname'] = 'Usando Moodle';
$string['supportforumslang'] = 'El foro de Moodle para hacer vida social en inglés está aquí:';
$string['supportforumslangname'] = 'Sala de estar de Moodle';
$string['supportforumslangurl'] = 'http://moodle.org/course/view.php?id=55';
$string['supportforumslist'] = 'También disponemos de otros foros, en muchos idiomas:';
$string['supportforumslistname'] = 'Listado de todos los cursos';
$string['supportintro'] = '¡No está solo!  Hay muchas formas de conseguir ayuda con Moodle si lo necesita.';
$string['top10sitesbycourses'] = 'Los 10 sitios con más cursos';
$string['top10sitesbyusers'] = 'Los 10 sitios con más usuarios';
$string['url-about'] = 'http://docs.moodle.org/all/es/Acerca_de_Moodle';
$string['url-features'] = 'http://docs.moodle.org/all/es/Características';
$string['url-install'] = 'http://docs.moodle.org/all/es/Instalación';
$string['url-standards'] = 'http://docs.moodle.org/en/Standards';
$string['url-userdocs'] = 'http://docs.moodle.org/all/es/Página_Principal';
$string['versionsused'] = 'Versiones utilizadas';
